import java.sql.*;

public class Esercizio_1_3 {
	public static void main(String[] arg){
		Connection con = null;
		try { // Caricamento del driver
//			Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
			Class.forName("com.ibm.db2.jcc.DB2Driver");
		}
		catch (Exception exClass) {
			System.err.println("Fallito il caricamento del driver");
			return;
		}
		try { // Apertura della connessione
//			String url = "jdbc:odbc:EsercSQL";
			String url = "jdbc:db2:esempio";
			con = DriverManager.getConnection(url);
		}
		catch (SQLException exSQL) {
			System.err.println("Fallita connessione al database.");
			System.err.println("SQL Error Code: " + exSQL.getErrorCode()
					+ ", SQL State" + exSQL.getSQLState());
			System.err.println("SQL Message: " + exSQL.getMessage());
			return;
		}

		try { // Esecuzione dell'interrogazione SQL
			Statement query = con.createStatement();
			String queryString =
				"SELECT F.Nome, Indirizzo, Citta,  " +
				"  Marca, Modello, Costo " +
				"FROM Fornitori AS F, Catalogo AS C, Prodotti AS P " +
				"WHERE C.CodiceFornitore = F.CodiceFornitore    " +
				"  AND C.CodiceProdotto = P.CodiceProdotto     " +
				"ORDER BY F.Nome, Marca, Modello ";

			ResultSet result = query.executeQuery(queryString);
			// 	Elaborazione del risultato
			String nomeF, indirizzoF, cittaF, marcaP, tipoP, modelloP;
			int costoC ; String nomeF_old = "";
			while (result.next()){
				nomeF = result.getString("Nome");
				indirizzoF = result.getString("Indirizzo");
				cittaF = result.getString("Citta");
				if (!nomeF_old.equals(nomeF)) {
					System.out.println(""
							+ "Nome: " + nomeF
							+ ", Indirizzo: " + indirizzoF
							+ ", Citt: " + cittaF );
					System.out.println(""
							+ "\tMarca"
							+ "\tModello"
							+ "\tCosto");
				}
				marcaP = result.getString("Marca");
				modelloP = result.getString("Modello") ;
				costoC = result.getInt("Costo") ;  // sia costo un intero
				System.out.println("\t" + marcaP
						+ "\t" + modelloP
						+ "\t" + costoC);
				nomeF_old = nomeF ;
			} // chiudo while
			result.close();
			query.close();

		}
		catch (SQLException exSQL){
			System.err.println("Errore nell'interrogazione");
			System.err.println("SQL Error Code: " + exSQL.getErrorCode()
					+ ", SQL State" + exSQL.getSQLState());
			System.err.println("SQL Message: " + exSQL.getMessage());
		}
		finally {
			try {
				con.close();
				System.out.println("Chiusa connessione al database.");
			}
			catch (SQLException exSQL) {
				System.err.println("Errore nella chiusura connessione.");
				System.err.println("SQL Error Code: " + exSQL.getErrorCode()
						+ ", SQL State" + exSQL.getSQLState());
				System.err.println("SQL Message: " + exSQL.getMessage());
			}
		}
	}
}